---
name: WeChat App
description: "WeChat desktop: read chats, send messages, search"
category: WeChat App
tools: [wechat_open, wechat_chats, wechat_read, wechat_send, wechat_search]
os: [darwin]
binaries: [osascript]
---

# WeChat Desktop App (macOS)

Control the WeChat desktop app on macOS via accessibility APIs. WeChat must be installed and logged in.

## Tools

### wechat_open
Activate WeChat and navigate to a tab.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| tab | string | No | Tab to open: `chats`, `contacts`, `favorites`, `moments` (default: chats) |

```json
{"tool": "wechat_open", "args": {"tab": "chats"}}
```

### wechat_chats
List recent chats with previews and timestamps.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| limit | integer | No | Max chats to return (default: 20) |

```json
{"tool": "wechat_chats", "args": {"limit": 10}}
```

Output format per chat: `<name> [Stuck on Top] [sender]: <preview> <timestamp>`

### wechat_read
Read messages from the current or a specified chat.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| contact | string | No | Contact/group name to read. Omit for current chat. |
| scroll_up | boolean | No | Scroll up to load older messages first (default: false) |

```json
{"tool": "wechat_read", "args": {"contact": "John"}}
{"tool": "wechat_read", "args": {"scroll_up": true}}
```

### wechat_send
Send a text message. Supports Chinese characters and emoji via clipboard.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| contact | string | No | Contact/group to send to. Omit for current chat. |
| message | string | Yes | Message text to send |

```json
{"tool": "wechat_send", "args": {"message": "Hello!"}}
{"tool": "wechat_send", "args": {"contact": "File Transfer", "message": "test message"}}
```

### wechat_search
Search contacts and chats.

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| query | string | Yes | Search query |
| select_first | boolean | No | Open the first result (default: false) |

```json
{"tool": "wechat_search", "args": {"query": "John", "select_first": true}}
```

## Limitations

- **Only visible messages**: `wechat_read` can only read messages currently on screen. Off-screen messages have empty AX titles.
- **No message history API**: Cannot fetch full chat history programmatically; use `scroll_up` to load more.
- **Search results**: May not be readable programmatically; use `select_first` to open the top result.
- **WeChat must be logged in**: These tools control the UI; they cannot log in or handle QR codes.
- **Sending uses clipboard**: The clipboard content will be replaced when sending messages.
