---
name: Terminal
description: Shell commands, persistent sessions, macOS Terminal.app control
category: Terminal
tools: [bash, bash_execute, terminal_run, terminal_open, terminal_type, terminal_read]
---

# Terminal Skills

Tools for executing shell commands and controlling macOS Terminal.app.

## Background Execution (No UI)

### bash
Execute a shell command in the background (no visible window).

```json
{
  "name": "bash",
  "parameters": {
    "command": "string (required) - Command to execute",
    "working_dir": "string (optional) - Working directory"
  }
}
```

**Example:**
```
bash(command="git status")
bash(command="npm install express")
bash(command="docker ps")
bash(command="ls -la", working_dir="/Users/me/projects")
```

---

### bash_execute
Execute bash with more options.

```json
{
  "name": "bash_execute",
  "parameters": {
    "command": "string (required) - Command to execute",
    "timeout": "integer (optional) - Timeout in seconds (default: 60, max: 300)",
    "working_dir": "string (optional) - Working directory"
  }
}
```

---

### terminal_run
Run command in a **persistent session** that maintains state across commands.

```json
{
  "name": "terminal_run",
  "parameters": {
    "command": "string (required) - Command to execute",
    "session_id": "string (optional) - Session ID (default: 'default')",
    "timeout": "integer (optional) - Timeout in seconds"
  }
}
```

**Example (state persists):**
```
terminal_run(command="cd /path/to/project", session_id="dev")
terminal_run(command="export NODE_ENV=production", session_id="dev")
terminal_run(command="npm run build", session_id="dev")  # Still in /path/to/project with NODE_ENV set
```

---

### terminal_list
List active terminal sessions.

```json
{
  "name": "terminal_list",
  "parameters": {}
}
```

---

### terminal_close
Close a terminal session.

```json
{
  "name": "terminal_close",
  "parameters": {
    "session_id": "string (optional) - Session to close (default: 'default')"
  }
}
```

---

## macOS Terminal.app (Visible Window)

These tools control the actual Terminal.app window that the user can see.

### terminal_open
Open Terminal.app and optionally run a command.

```json
{
  "name": "terminal_open",
  "parameters": {
    "command": "string (optional) - Command to run",
    "new_window": "boolean (optional) - Open in new window vs tab"
  }
}
```

**Example:**
```
terminal_open()  # Just open Terminal
terminal_open(command="htop")  # Open and run htop
terminal_open(command="npm run dev", new_window=true)
```

---

### terminal_type
Type and execute a command in the visible Terminal window.

```json
{
  "name": "terminal_type",
  "parameters": {
    "command": "string (required) - Command to type",
    "press_enter": "boolean (optional) - Press Enter after typing (default: true)"
  }
}
```

**Example:**
```
terminal_type(command="git status")
terminal_type(command="ssh user@server", press_enter=true)
```

---

### terminal_read
Read the visible content from Terminal window.

```json
{
  "name": "terminal_read",
  "parameters": {
    "lines": "integer (optional) - Number of lines from end (default: 50)"
  }
}
```

---

### terminal_exec
Execute command in Terminal.app and wait for output.

```json
{
  "name": "terminal_exec",
  "parameters": {
    "command": "string (required) - Command to execute",
    "wait_seconds": "integer (optional) - Seconds to wait (default: 5)"
  }
}
```

**Example:**
```
terminal_exec(command="ls -la", wait_seconds=2)
terminal_exec(command="npm install", wait_seconds=30)
```

---

### terminal_status
Check if Terminal.app is running.

```json
{
  "name": "terminal_status",
  "parameters": {}
}
```

---

## When to Use Which

| Scenario | Tool |
|----------|------|
| Quick command, don't need to see it | `bash` |
| Multiple commands that share state | `terminal_run` with same `session_id` |
| Show user what's happening | `terminal_open` or `terminal_exec` |
| Long-running process user should see | `terminal_open` |
| Read what's in Terminal window | `terminal_read` |
