---
name: Teams
description: "Microsoft Teams via browser automation (read/send messages, navigate channels)"
category: Messaging
tools: [browser_navigate, browser_snapshot, browser_click, browser_type, browser_wait, browser_press_key]
env_vars: [BROWSER_STORAGE_STATE]
---

# Microsoft Teams (Browser Automation)

Interact with Microsoft Teams via Playwright browser automation. Requires a saved auth session from `assistant capture-auth`.

## Setup

Before using Teams, capture your login session once:

```bash
assistant capture-auth https://teams.microsoft.com
```

Log in with your credentials (2FA is fine), then close the browser. Add the output path to `.env`:

```
BROWSER_STORAGE_STATE=config/teams_microsoft_com_state.json
```

Restart the assistant. The browser will now load your Teams session automatically.

## Opening Teams

Navigate to the Teams web app:

```
browser_navigate(url="https://teams.microsoft.com")
```

Then take a snapshot to see the page structure:

```
browser_snapshot()
```

## Common Operations

### Read Messages in a Channel/Chat

1. Navigate to Teams:
   ```
   browser_navigate(url="https://teams.microsoft.com")
   ```

2. Snapshot to find the chat or channel list:
   ```
   browser_snapshot()
   ```

3. Click on a chat or channel by its ref:
   ```
   browser_click(ref="e15")
   ```

4. Snapshot again to read the messages:
   ```
   browser_snapshot()
   ```

### Send a Message

1. Navigate to the chat/channel (see above)

2. Find the message input box in the snapshot (usually a textbox with placeholder like "Type a message")

3. Click the input to focus it:
   ```
   browser_click(ref="e42")
   ```

4. Type the message and submit:
   ```
   browser_type(ref="e42", text="Hello from the assistant!", submit=true)
   ```

### Search for a Chat or Channel

1. Click the search bar (usually at the top):
   ```
   browser_click(ref="e3")
   ```

2. Type the search query:
   ```
   browser_type(ref="e3", text="project standup", submit=true)
   ```

3. Snapshot to see results:
   ```
   browser_snapshot()
   ```

4. Click the desired result:
   ```
   browser_click(ref="e20")
   ```

### Switch Between Chats and Teams

Use the left sidebar navigation. After a snapshot, look for refs on:
- "Chat" button - switches to direct messages
- "Teams" button - switches to team channels
- "Activity" button - shows notifications

```
browser_click(ref="e2")   # Click "Chat" in sidebar
browser_snapshot()         # See chat list
```

### Direct URL Navigation

You can navigate directly to specific chats or channels using Teams URLs:

```
browser_navigate(url="https://teams.microsoft.com/_#/conversations/General?threadId=19:abc@thread.v2")
```

## Workflow Example: Check and Reply to Messages

```
# 1. Open Teams
browser_navigate(url="https://teams.microsoft.com")

# 2. See what's on screen
browser_snapshot()

# 3. Click on a chat with unread messages
browser_click(ref="e10")

# 4. Read the conversation
browser_snapshot()

# 5. Click message input
browser_click(ref="e35")

# 6. Type and send reply
browser_type(ref="e35", text="Got it, I'll look into this.", submit=true)

# 7. Verify message was sent
browser_snapshot()
```

## Tips

- Always call `browser_snapshot()` after navigation or clicks to see updated content
- Element refs change after page updates - always get a fresh snapshot before interacting
- Use `browser_wait(time=2)` if the page is still loading after navigation
- Teams web may show "Use the desktop app" prompts - dismiss them by clicking "Use the web app instead"
- If the session expires, re-run `assistant capture-auth https://teams.microsoft.com`
- Use `browser_set_mode(mode="headed")` to watch the automation visually for debugging
