---
name: Tasks
description: Task management, subtasks, scheduling
category: Tasks
tools: [list_tasks, create_task, create_subtask, split_task, update_task_status, create_scheduled_task]
---

# Task Management Skills

Tools for creating and managing tasks and subtasks.

## Viewing Tasks

### list_tasks
List all tasks with their status.

```json
{
  "name": "list_tasks",
  "parameters": {
    "status": "string (optional) - Filter by status: 'TODO', 'IN-PROGRESS', 'DONE', 'WAITING'",
    "include_subtasks": "boolean (optional) - Include subtasks (default: true)"
  }
}
```

**Example:**
```
list_tasks()
list_tasks(status="TODO")
list_tasks(status="IN-PROGRESS", include_subtasks=true)
```

---

### get_subtasks
Get subtasks of a parent task.

```json
{
  "name": "get_subtasks",
  "parameters": {
    "parent_id": "string (required) - Parent task ID"
  }
}
```

---

## Creating Tasks

### create_task
Create a new task.

```json
{
  "name": "create_task",
  "parameters": {
    "title": "string (required) - Task title",
    "description": "string (optional) - Task description",
    "priority": "string (optional) - Priority: 'A', 'B', 'C' (default: 'B')",
    "tags": "array (optional) - List of tags",
    "deadline": "string (optional) - Deadline date (YYYY-MM-DD)"
  }
}
```

**Example:**
```
create_task(title="Review PR #123")
create_task(
  title="Prepare presentation",
  description="Q4 sales review for Monday meeting",
  priority="A",
  deadline="2024-02-15"
)
```

---

### create_subtask
Create a subtask under a parent task.

```json
{
  "name": "create_subtask",
  "parameters": {
    "parent_id": "string (required) - Parent task ID",
    "title": "string (required) - Subtask title",
    "description": "string (optional) - Subtask description"
  }
}
```

**Example:**
```
create_subtask(parent_id="task-001", title="Research competitors")
create_subtask(parent_id="task-001", title="Create slides")
create_subtask(parent_id="task-001", title="Practice presentation")
```

---

### split_task
Split a complex task into multiple subtasks automatically.

```json
{
  "name": "split_task",
  "parameters": {
    "task_id": "string (required) - Task ID to split",
    "subtasks": "array (required) - List of subtask titles"
  }
}
```

**Example:**
```
split_task(
  task_id="task-001",
  subtasks=["Research", "Design", "Implement", "Test", "Document"]
)
```

---

## Updating Tasks

### update_task_status
Update the status of a task.

```json
{
  "name": "update_task_status",
  "parameters": {
    "task_id": "string (required) - Task ID",
    "status": "string (required) - New status: 'TODO', 'IN-PROGRESS', 'DONE', 'WAITING'"
  }
}
```

**Example:**
```
update_task_status(task_id="task-001", status="IN-PROGRESS")
update_task_status(task_id="task-001", status="DONE")
```

**Status meanings:**
- `TODO` - Not started
- `IN-PROGRESS` - Currently working on
- `WAITING` - Blocked or waiting for something
- `DONE` - Completed

---

## Scheduled Tasks

### create_scheduled_task
Create a recurring scheduled task.

```json
{
  "name": "create_scheduled_task",
  "parameters": {
    "title": "string (required) - Task title",
    "description": "string (optional) - Description",
    "prompt": "string (required) - What to do when task runs",
    "schedule": "string (required) - Schedule pattern"
  }
}
```

**Schedule patterns:**
- `daily@08:00` - Every day at 8am
- `weekly@monday@09:00` - Every Monday at 9am
- `hourly` - Every hour

**Example:**
```
create_scheduled_task(
  title="Daily standup reminder",
  prompt="Remind me about the 9am standup meeting",
  schedule="daily@08:45"
)
```

---

### list_scheduled_tasks
List all scheduled tasks.

```json
{
  "name": "list_scheduled_tasks",
  "parameters": {}
}
```

---

## Common Workflows

### Break down a project
```
1. create_task(title="Launch new feature")
2. split_task(task_id="...", subtasks=["Design", "Backend", "Frontend", "Testing", "Deploy"])
3. For each subtask, update status as you work
```

### Daily task review
```
1. list_tasks(status="IN-PROGRESS")  # What am I working on?
2. list_tasks(status="TODO")  # What's next?
```

### Complete a task
```
1. update_task_status(task_id="...", status="DONE")
```
