---
name: Messaging
description: "WhatsApp: send messages, check status"
category: Messaging
tools: [whatsapp_send, whatsapp_status, whatsapp_contacts]
---

# Messaging Skills (WhatsApp)

Tools for sending and receiving WhatsApp messages.

## Connection

WhatsApp uses your personal account via QR code login (like WhatsApp Web).

### First-time setup:
1. Start the assistant
2. A QR code appears in the terminal
3. Open WhatsApp on your phone → Settings → Linked Devices → Link a Device
4. Scan the QR code
5. Connected!

Session is saved - no QR needed on subsequent runs.

---

## Tools

### whatsapp_send
Send a WhatsApp message to a phone number.

```json
{
  "name": "whatsapp_send",
  "parameters": {
    "phone": "string (required) - Phone number with country code (no + or spaces)",
    "message": "string (required) - Message to send"
  }
}
```

**Example:**
```
whatsapp_send(phone="14155551234", message="Hello! How are you?")
whatsapp_send(phone="8613800138000", message="Meeting at 3pm")
```

**Phone number format:**
- US: `14155551234` (1 = country code)
- UK: `447911123456` (44 = country code)
- China: `8613800138000` (86 = country code)
- No `+`, spaces, or dashes

---

### whatsapp_status
Check WhatsApp connection status.

```json
{
  "name": "whatsapp_status",
  "parameters": {}
}
```

**Returns:**
- Connection status (connected/disconnected)
- Account JID (your WhatsApp ID)

---

### whatsapp_contacts
List synced WhatsApp contacts.

```json
{
  "name": "whatsapp_contacts",
  "parameters": {
    "limit": "integer (optional) - Max contacts to return (default: 50)"
  }
}
```

**Note:** Contacts sync from your phone over time. May be empty initially.

---

## Receiving Messages

When someone sends you a WhatsApp message:
1. The assistant receives it automatically
2. Processes it using the full agent (with all tools)
3. Sends a reply

**You can message yourself** using WhatsApp's "Message yourself" feature to test.

---

## Common Workflows

### Send a reminder
```
whatsapp_send(phone="14155551234", message="Don't forget the meeting at 3pm!")
```

### Check if connected
```
whatsapp_status()
```

### Send to multiple people
```
whatsapp_send(phone="14155551234", message="Team meeting moved to 4pm")
whatsapp_send(phone="14155555678", message="Team meeting moved to 4pm")
```

---

## Troubleshooting

**"Not connected" error:**
- Restart the assistant to re-scan QR code
- Check if your phone has internet

**Message not delivered:**
- Verify phone number format (country code, no special characters)
- Check WhatsApp status on your phone

**Session expired:**
- Delete `data/whatsapp.db` and restart to re-login

---

## Privacy Note

This uses your personal WhatsApp account. Messages appear in your WhatsApp chat history on your phone.
