---
name: Memory
description: Long-term memory, chat history, semantic search
category: Memory
tools: [memory_save, memory_get, memory_search, memory_list, memory_delete]
---

# Memory Skills

Tools for long-term memory storage and chat history.

## Long-Term Memory

Persistent storage for facts, preferences, and context that should survive across conversations.

### memory_save
Save information to long-term memory.

```json
{
  "name": "memory_save",
  "parameters": {
    "category": "string (required) - Category for organization",
    "key": "string (required) - Unique key within category",
    "value": "string (required) - Information to remember",
    "tags": "array (optional) - Tags for searching"
  }
}
```

**Example:**
```
memory_save(
  category="user_preferences",
  key="timezone",
  value="America/Chicago (CST/CDT)"
)

memory_save(
  category="contacts",
  key="john_smith",
  value="John Smith - john@example.com - Product Manager at Acme Corp",
  tags=["work", "product"]
)

memory_save(
  category="projects",
  key="website_redesign",
  value="Website redesign project - deadline March 15, using React + Tailwind"
)
```

**Recommended categories:**
- `user_preferences` - Timezone, communication style, etc.
- `contacts` - People and their details
- `projects` - Project information
- `facts` - General facts to remember
- `context` - Background information

---

### memory_get
Retrieve a specific memory by category and key.

```json
{
  "name": "memory_get",
  "parameters": {
    "category": "string (required) - Category",
    "key": "string (required) - Key"
  }
}
```

**Example:**
```
memory_get(category="user_preferences", key="timezone")
```

---

### memory_search
Search memories by query.

```json
{
  "name": "memory_search",
  "parameters": {
    "query": "string (required) - Search query",
    "category": "string (optional) - Limit to category",
    "limit": "integer (optional) - Max results (default: 20)"
  }
}
```

**Example:**
```
memory_search(query="project deadline")
memory_search(query="john", category="contacts")
```

---

### memory_list
List all memories in a category.

```json
{
  "name": "memory_list",
  "parameters": {
    "category": "string (required) - Category to list",
    "limit": "integer (optional) - Max results (default: 50)"
  }
}
```

---

### memory_categories
List all memory categories.

```json
{
  "name": "memory_categories",
  "parameters": {}
}
```

---

### memory_recent
Get recently accessed/updated memories.

```json
{
  "name": "memory_recent",
  "parameters": {
    "limit": "integer (optional) - Max results (default: 10)"
  }
}
```

---

### memory_delete
Delete a memory.

```json
{
  "name": "memory_delete",
  "parameters": {
    "category": "string (required) - Category",
    "key": "string (required) - Key"
  }
}
```

---

### memory_stats
Get memory statistics.

```json
{
  "name": "memory_stats",
  "parameters": {}
}
```

---

## Chat History

Access previous conversation history.

### chat_sessions
List all chat sessions.

```json
{
  "name": "chat_sessions",
  "parameters": {}
}
```

**Returns:** Session IDs, message counts, timestamps.

---

### chat_history
Get conversation history from a session.

```json
{
  "name": "chat_history",
  "parameters": {
    "session_id": "string (required) - Session ID",
    "limit": "integer (optional) - Max messages (default: 50)"
  }
}
```

---

### chat_summary
Get a condensed summary of a session.

```json
{
  "name": "chat_summary",
  "parameters": {
    "session_id": "string (required) - Session ID",
    "max_messages": "integer (optional) - Max to include (default: 20)"
  }
}
```

---

## When to Save Memories

**Proactively save** when you learn:
- User preferences (timezone, communication style)
- Contact information (names, emails, roles)
- Project details (deadlines, requirements)
- Important facts mentioned in conversation
- Decisions made or conclusions reached

**Example triggers:**
- "My email is john@example.com" → Save to contacts
- "I'm in Pacific time" → Save to user_preferences
- "The deadline is March 15" → Save to projects
- "Remember that..." → Save to facts

---

## Memory vs Chat History

| Feature | Memory | Chat History |
|---------|--------|--------------|
| Purpose | Long-term facts | Conversation record |
| Structure | Categorized key-value | Chronological messages |
| Persistence | Permanent until deleted | Permanent |
| Use case | "What's John's email?" | "What did we discuss yesterday?" |
