---
name: Files & Code
description: Read/write files, run Python/bash, execute code
category: Files & Code
tools: [read_file, write_file, edit_file, glob, grep, python_run]
---

# Files & Code Skills

Tools for reading, writing, and executing files and code.

## Tools

### read_file
Read the contents of a file.

```json
{
  "name": "read_file",
  "parameters": {
    "path": "string (required) - File path to read",
    "encoding": "string (optional) - File encoding, default: utf-8"
  }
}
```

**Example:**
```
read_file(path="/path/to/file.txt")
read_file(path="src/main.go")
```

---

### write_file
Create or overwrite a file with content.

```json
{
  "name": "write_file",
  "parameters": {
    "path": "string (required) - File path to write",
    "content": "string (required) - Content to write"
  }
}
```

**Example:**
```
write_file(path="output.txt", content="Hello World")
```

---

### edit_file
Make precise edits to an existing file by replacing text.

```json
{
  "name": "edit_file",
  "parameters": {
    "path": "string (required) - File path to edit",
    "old_text": "string (required) - Text to find and replace",
    "new_text": "string (required) - Replacement text"
  }
}
```

**Example:**
```
edit_file(path="config.json", old_text='"debug": false', new_text='"debug": true')
```

---

### list_directory
List files and directories in a path.

```json
{
  "name": "list_directory",
  "parameters": {
    "path": "string (required) - Directory path to list"
  }
}
```

---

### glob
Search for files matching a pattern.

```json
{
  "name": "glob",
  "parameters": {
    "pattern": "string (required) - Glob pattern (e.g., '*.py', 'src/**/*.go')"
  }
}
```

---

### grep
Search file contents for a pattern.

```json
{
  "name": "grep",
  "parameters": {
    "pattern": "string (required) - Search pattern (regex)",
    "path": "string (optional) - Directory or file to search",
    "include": "string (optional) - File pattern to include"
  }
}
```

---

### python_run
Execute Python code and return output.

```json
{
  "name": "python_run",
  "parameters": {
    "code": "string (required) - Python code to execute",
    "timeout": "integer (optional) - Timeout in seconds (default: 60)"
  }
}
```

**Example:**
```
python_run(code="print(2 + 2)")
python_run(code="import pandas as pd\ndf = pd.read_csv('data.csv')\nprint(df.head())")
```

**Notes:**
- Use `print()` to output results
- Matplotlib plots are auto-saved as images
- Access to common libraries (pandas, numpy, requests, etc.)

---

### python_run_file
Execute a Python script file.

```json
{
  "name": "python_run_file",
  "parameters": {
    "file_path": "string (required) - Path to .py file",
    "args": "array (optional) - Command line arguments"
  }
}
```

---

### python_install
Install Python packages via pip.

```json
{
  "name": "python_install",
  "parameters": {
    "packages": "array (required) - Package names to install",
    "upgrade": "boolean (optional) - Upgrade if exists"
  }
}
```

**Example:**
```
python_install(packages=["pandas", "matplotlib"])
```

---

### python_list_packages
List installed Python packages.

```json
{
  "name": "python_list_packages",
  "parameters": {
    "filter": "string (optional) - Filter by name"
  }
}
```
