---
name: Email
description: "Gmail: read, search, send, drafts"
category: Email
tools: [gmail_list_unread, gmail_search, gmail_read, gmail_send, gmail_create_draft]
env_vars: [GMAIL_CLIENT_ID]
---

# Email Skills (Gmail)

Tools for managing Gmail: reading, searching, and sending emails.

## Reading Emails

### gmail_list_unread
List unread emails in the inbox.

```json
{
  "name": "gmail_list_unread",
  "parameters": {
    "max_results": "integer (optional) - Maximum emails to return (default: 10)"
  }
}
```

**Example:**
```
gmail_list_unread()
gmail_list_unread(max_results=5)
```

**Returns:** List of unread emails with ID, from, subject, date, snippet.

---

### gmail_search
Search emails with Gmail query syntax.

```json
{
  "name": "gmail_search",
  "parameters": {
    "query": "string (required) - Gmail search query",
    "max_results": "integer (optional) - Maximum results (default: 10)"
  }
}
```

**Example:**
```
gmail_search(query="from:boss@company.com")
gmail_search(query="subject:invoice after:2024/01/01")
gmail_search(query="is:unread has:attachment")
gmail_search(query="label:important newer_than:7d")
```

**Gmail Query Syntax:**
- `from:sender@email.com` - From specific sender
- `to:recipient@email.com` - To specific recipient
- `subject:word` - Subject contains word
- `is:unread` / `is:read` - Read status
- `has:attachment` - Has attachments
- `after:2024/01/01` / `before:2024/12/31` - Date range
- `newer_than:7d` / `older_than:1m` - Relative date
- `label:labelname` - Has label
- `in:inbox` / `in:sent` / `in:trash` - Location

---

### gmail_read
Read the full content of a specific email.

```json
{
  "name": "gmail_read",
  "parameters": {
    "message_id": "string (required) - Email message ID from list/search"
  }
}
```

**Example:**
```
gmail_read(message_id="18d5a7b3c4e5f6g7")
```

**Returns:** Full email content including headers, body, and attachments info.

---

## Sending Emails

### gmail_send
Send an email immediately.

```json
{
  "name": "gmail_send",
  "parameters": {
    "to": "string (required) - Recipient email address",
    "subject": "string (required) - Email subject",
    "body": "string (required) - Email body (plain text or HTML)",
    "cc": "string (optional) - CC recipients",
    "bcc": "string (optional) - BCC recipients"
  }
}
```

**Example:**
```
gmail_send(
  to="colleague@company.com",
  subject="Meeting Tomorrow",
  body="Hi,\n\nJust confirming our meeting tomorrow at 2pm.\n\nBest regards"
)
```

---

### gmail_create_draft
Create a draft email for review before sending.

```json
{
  "name": "gmail_create_draft",
  "parameters": {
    "to": "string (required) - Recipient email address",
    "subject": "string (required) - Email subject",
    "body": "string (required) - Email body"
  }
}
```

**Example:**
```
gmail_create_draft(
  to="client@example.com",
  subject="Project Update",
  body="Dear Client,\n\nHere's the weekly update..."
)
```

**Note:** Drafts require `gmail.compose` scope. If you get permission errors, use `gmail_send` instead.

---

## Common Workflows

### Check for important emails
```
1. gmail_search(query="is:unread is:important")
2. gmail_read(message_id="...")  # For each important email
```

### Daily email summary
```
1. gmail_list_unread(max_results=10)
2. Summarize the list for the user
```

### Reply to an email
```
1. gmail_read(message_id="...")  # Read the original
2. gmail_send(to="sender", subject="Re: Original Subject", body="...")
```

---

## Authentication

Gmail tools require OAuth authentication. If not connected:
1. Go to Settings in the web UI
2. Click "Connect Gmail"
3. Authorize access

The token is saved locally and refreshes automatically.
