---
name: Calendar
description: "Google Calendar: view, create, delete events"
category: Calendar
tools: [calendar_today, calendar_upcoming, calendar_create, calendar_delete]
env_vars: [CALENDAR_CLIENT_ID]
---

# Calendar Skills (Google Calendar)

Tools for managing Google Calendar events.

## Viewing Events

### calendar_today
Get today's calendar events.

```json
{
  "name": "calendar_today",
  "parameters": {}
}
```

**Example:**
```
calendar_today()
```

**Returns:** List of events for today with time, title, location, description.

---

### calendar_upcoming
Get upcoming events within a time range.

```json
{
  "name": "calendar_upcoming",
  "parameters": {
    "days": "integer (optional) - Number of days to look ahead (default: 7)",
    "max_results": "integer (optional) - Maximum events to return (default: 20)"
  }
}
```

**Example:**
```
calendar_upcoming()  # Next 7 days
calendar_upcoming(days=30)  # Next month
calendar_upcoming(days=1, max_results=5)  # Tomorrow, max 5 events
```

---

## Creating Events

### calendar_create
Create a new calendar event.

```json
{
  "name": "calendar_create",
  "parameters": {
    "title": "string (required) - Event title",
    "start_time": "string (required) - Start time (ISO 8601 or natural language)",
    "end_time": "string (required) - End time",
    "description": "string (optional) - Event description",
    "location": "string (optional) - Event location",
    "attendees": "array (optional) - List of attendee email addresses"
  }
}
```

**Example:**
```
calendar_create(
  title="Team Meeting",
  start_time="2024-02-15T14:00:00",
  end_time="2024-02-15T15:00:00",
  description="Weekly sync",
  location="Conference Room A"
)

calendar_create(
  title="Lunch with John",
  start_time="tomorrow 12:00",
  end_time="tomorrow 13:00",
  location="Cafe Downtown"
)
```

**Time formats:**
- ISO 8601: `2024-02-15T14:00:00`
- With timezone: `2024-02-15T14:00:00-06:00`
- Natural: `tomorrow 2pm`, `next Monday 10:00`

---

## Deleting Events

### calendar_delete
Delete a calendar event.

```json
{
  "name": "calendar_delete",
  "parameters": {
    "event_id": "string (required) - Event ID from calendar_today or calendar_upcoming"
  }
}
```

**Example:**
```
calendar_delete(event_id="abc123xyz")
```

---

## Common Workflows

### Check schedule before booking
```
1. calendar_upcoming(days=7)
2. Find available slot
3. calendar_create(...)
```

### Morning briefing
```
1. calendar_today()
2. Summarize the day's schedule for user
```

### Reschedule a meeting
```
1. calendar_upcoming() - find the event
2. calendar_delete(event_id="...")
3. calendar_create(...) - with new time
```

---

## Authentication

Calendar tools require OAuth authentication. If not connected:
1. Go to Settings in the web UI
2. Click "Connect Calendar"
3. Authorize access

Uses the same Google account as Gmail.
