---
name: Browser
description: Web automation, cookies, authenticated browsing
category: Browser
tools: [browser_navigate, browser_snapshot, browser_click, browser_type, browser_inject_cookies]
binaries: [npx]
---

# Browser Skills

Tools for web automation using Playwright.

## Navigation & Content

### browser_navigate
Navigate the browser to a URL.

```json
{
  "name": "browser_navigate",
  "parameters": {
    "url": "string (required) - URL to navigate to"
  }
}
```

**Example:**
```
browser_navigate(url="https://github.com")
browser_navigate(url="https://amazon.com/cart")
```

---

### browser_snapshot
Get an accessibility snapshot of the current page. Returns page content with element references (refs) for interaction.

```json
{
  "name": "browser_snapshot",
  "parameters": {}
}
```

**Example output:**
```
[page] Amazon.com Shopping Cart
  [heading] Shopping Cart
  [text] 3 items in your cart
  [link ref="e5"] Proceed to checkout
  [button ref="e8"] Delete
  [textbox ref="e12"] Quantity
```

Use the `ref` values with `browser_click` and `browser_type`.

---

## Interaction

### browser_click
Click on an element using its ref from the snapshot.

```json
{
  "name": "browser_click",
  "parameters": {
    "ref": "string (required) - Element reference (e.g., 'e5')",
    "element": "string (optional) - Element description for fallback"
  }
}
```

**Example:**
```
browser_click(ref="e5")
browser_click(ref="e8", element="Delete button")
```

---

### browser_type
Type text into an input field.

```json
{
  "name": "browser_type",
  "parameters": {
    "ref": "string (required) - Element reference",
    "text": "string (required) - Text to type",
    "submit": "boolean (optional) - Press Enter after typing"
  }
}
```

**Example:**
```
browser_type(ref="e12", text="2")
browser_type(ref="search-box", text="laptop", submit=true)
```

---

## Cookies (Authenticated Access)

To access authenticated sites (Amazon, GitHub, etc.), inject cookies from your local browser.

### browser_list_cookies
List cookies from local browsers for a domain.

```json
{
  "name": "browser_list_cookies",
  "parameters": {
    "domain": "string (required) - Domain to get cookies for",
    "browser": "string (optional) - Browser: 'chrome', 'arc', 'firefox', 'safari'"
  }
}
```

**Example:**
```
browser_list_cookies(domain="amazon.com")
browser_list_cookies(domain="github.com", browser="chrome")
```

---

### browser_inject_cookies
Inject cookies from local browser into Playwright session.

```json
{
  "name": "browser_inject_cookies",
  "parameters": {
    "domain": "string (required) - Domain to inject cookies for",
    "browser": "string (optional) - Source browser"
  }
}
```

**Example:**
```
browser_inject_cookies(domain="amazon.com")
```

**Note:** User must be logged into the site in their local browser for this to work.

---

### browser_save_cookies_state
Save current cookies to a storage state file.

```json
{
  "name": "browser_save_cookies_state",
  "parameters": {
    "path": "string (required) - Path to save state file"
  }
}
```

---

## Workflow: Accessing Authenticated Sites

1. **Inject cookies** from user's browser:
   ```
   browser_inject_cookies(domain="amazon.com")
   ```

2. **Navigate** to the page:
   ```
   browser_navigate(url="https://amazon.com/cart")
   ```

3. **Get page content**:
   ```
   browser_snapshot()
   ```

4. **Interact** with elements:
   ```
   browser_click(ref="e5")
   browser_type(ref="e12", text="2")
   ```

---

## Tips

- Always call `browser_snapshot()` after navigation to see the page
- Element refs change after page updates - get a new snapshot
- For login-protected pages, inject cookies first
- Some sites may detect automation - use realistic delays
